// miniprogram/pages/home.js

var utilMd5 = require('md5.js');  

Page({

  /**
   * Page initial data
   */
  data: {

  },

  /**
   * Lifecycle function--Called when page load
   */
  onLoad: function (options) {

  },

  getUserOpenID: function () {
    wx.showLoading({
      mask: true
    })

    var openid = wx.getStorageSync('useropenid')
    if (openid == '') {
        wx.cloud.callFunction({
          name: 'getUserOpenID',
          data: {},
          success: res => {
            console.log("openid:", res.result.openid)
            this.setData({
              openid: res.result.openid
            })
            this.qfPayOpenAPI();
            wx.setStorageSync('useropenid', res.result.openid)
          },
          fail: err => {
            console.log("Failed")
            console.log(err)
          },
          complete: res => {
          }
        })
      }
    else {
      console.log("User openid already acquired:", openid)
      this.setData({
        openid: openid
      })
      this.qfPayOpenAPI();
     }
    },

  qfPayOpenAPI: function () {
    let app_code = 'ENTER_CODE';
    let client_key = 'ENTER_KEY';
    let environment = 'https://openapi-sg.qfapi.com/trade/v1/payment';
    let openid = this.data.openid;
    let amount = this.data.amount * 100;
    let random_number = String(Math.round(Math.random() * 1000000000));
    let datetime = new Date().toISOString().replace(/T/, ' ').replace(/\..+/, '');

    let payload = {
      txamt: amount,
      txcurrcd: 'SGD',
      pay_type: '800213',
      out_trade_no: random_number,
      txdtm: datetime,
      sub_openid: openid
    };

    var ordered = {};
    Object.keys(payload).sort().forEach(function(key) {
      ordered[key] = payload[key] });
    console.log(ordered)

    var str = [];
    for (var p in ordered)
    if (ordered.hasOwnProperty(p)) {
    str.push((p) + "=" + (ordered[p]));
    }
    var string = str.join("&")+client_key;
    console.log(string)

    var signature = utilMd5.hexMD5(string).toUpperCase()
    console.log(signature)

    wx.request({
      url: environment,
      data: payload,
      method: 'POST',
      header: {
        'X-QF-APPCODE': app_code,
        'X-QF-SIGN': signature,
        'content-Type': 'application/x-www-form-urlencoded'
      },
      success: (res) => {
        if (res.statusCode == 200) {
          console.log(res)
          console.log(res.data)
          this.weChatPayment(res);
        }
      },
      fail: (err) => {
        console.log(err);
      },
      complete: (res) => {
        wx.hideLoading();
        console.log("API request completed")
      }
    })
   },

  weChatPayment: function(res) {
   wx.requestPayment(
    {
    'timeStamp': res.data.pay_params.timeStamp,
    'nonceStr': res.data.pay_params.nonceStr,
    'package': res.data.pay_params.package,
    'signType': 'MD5',
    'paySign': res.data.pay_params.paySign,
    'success':function(res){},
    'fail':function(res){},
    'complete':function(res){}
    })
  },

  inputAmount(event) {
    this.setData({
      amount: event.detail.value
    })
  },

  smallModal: function (e) {
    wx.showModal({
      content: 'The entered amount is too small. SGD 0.01 is the minimum payment amount that can be processed.',
      confirmText: "Confirm",
      confirmColor: "#727E99",
      showCancel: false
    })
  },

  bigModal: function (e) {
    wx.showModal({
      content: 'The entered amount is too big. SGD 10,000 is the maximum payment amount that can be processed.',
      confirmText: "Confirm",
      confirmColor: "#727E99",
      showCancel: false
    })
  },

    
})