/*
 * Decompiled with CFR 0.152.
 */
package com.qfpay.haojin;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.util.Log;
import com.qfpay.haojin.BaseRequest;
import com.qfpay.haojin.BaseResponse;
import com.qfpay.haojin.CardAdjustResp;
import com.qfpay.haojin.CardSettleResp;
import com.qfpay.haojin.CheckTradeSumResp;
import com.qfpay.haojin.CollectionResp;
import com.qfpay.haojin.Config;
import com.qfpay.haojin.GetChannelConfigResp;
import com.qfpay.haojin.GetTransListResp;
import com.qfpay.haojin.GetTransResp;
import com.qfpay.haojin.GetUserConfigResp;
import com.qfpay.haojin.ITradeAPI;
import com.qfpay.haojin.ReceiptReprintResponse;
import com.qfpay.haojin.RefundResp;
import com.qfpay.haojin.preauth.PreAuthTransCancelResp;
import com.qfpay.haojin.preauth.PreAuthTransDeductResp;
import com.qfpay.haojin.preauth.PreAuthTransDetailResp;
import com.qfpay.haojin.preauth.PreAuthTransListResp;

public final class TradeApiImplByActivity
implements ITradeAPI {
    private static final String TAG = "TradeApiImplByActivity";
    private static final int HAOJIN_REQUEST_CODE = 999;
    private Activity mAct;

    public TradeApiImplByActivity(Activity activity) {
        if (activity == null) {
            throw new NullPointerException("the activity instance is null.");
        }
        this.mAct = activity;
    }

    @Override
    public int doTrade(BaseRequest req) {
        ComponentName componentName;
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)"nearmcht://extra-view-collection-service"));
        intent.setPackage(Config.QFPAY_APP_ID);
        Bundle bundle = new Bundle();
        req.saveToBundle((Context)this.mAct, bundle);
        intent.putExtras(bundle);
        if (Config.Is_Debug) {
            Log.d((String)TAG, (String)("the request params: " + bundle.toString()));
        }
        if ((componentName = intent.resolveActivity(this.mAct.getPackageManager())) == null) {
            return 108;
        }
        try {
            this.mAct.startActivityForResult(intent, 999);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 109;
        }
        return 0;
    }

    @Override
    @Nullable
    public BaseResponse parseResponse(int reqCode, int resCode, Intent data) {
        BaseResponse baseResponse = null;
        if (reqCode == 999 && data != null) {
            int funcType = data.getIntExtra("func_type", -1);
            Bundle respParams = data.getExtras();
            if (Config.Is_Debug) {
                Log.d((String)TAG, (String)("the response params: " + respParams));
            }
            switch (funcType) {
                case 1: {
                    baseResponse = new CollectionResp();
                    break;
                }
                case 2: {
                    baseResponse = new RefundResp();
                    break;
                }
                case 3: {
                    baseResponse = new GetTransListResp();
                    break;
                }
                case 4: {
                    baseResponse = new GetTransResp();
                    break;
                }
                case 5: {
                    baseResponse = new CheckTradeSumResp();
                    break;
                }
                case 6: {
                    baseResponse = new GetChannelConfigResp();
                    break;
                }
                case 8: {
                    baseResponse = new CardAdjustResp();
                    break;
                }
                case 7: {
                    baseResponse = new CardSettleResp();
                    break;
                }
                case 9: {
                    baseResponse = new GetUserConfigResp();
                    break;
                }
                case 12: {
                    baseResponse = new PreAuthTransCancelResp();
                    break;
                }
                case 13: {
                    baseResponse = new PreAuthTransDeductResp();
                    break;
                }
                case 11: {
                    baseResponse = new PreAuthTransDetailResp();
                    break;
                }
                case 10: {
                    baseResponse = new PreAuthTransListResp();
                    break;
                }
                case 14: {
                    baseResponse = new ReceiptReprintResponse();
                    break;
                }
            }
            if (baseResponse != null && respParams != null) {
                try {
                    baseResponse.readFromBundle(respParams);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return baseResponse;
    }
}

